% Bisection method to solve 2.0*x-3.0*sin(x)+5.0=0
%
% Define an anonymous function
% Set the tolerance for convergence
%
f=@(x)2.0*x-3.0*sin(x)+5.0;
tol=0.5e-5;
%
% Read in lower guess and higher guess
% Check that interval includes a zero and is increasing
%
yl=1.0; yu=1.0;
while yl*yu > 0
  xl=input('Please enter the lower end of initial interval [-3]: ');
  if isempty(xl)
    xl=-3.0;
  end
  xu=input('Please enter the upper end of initial interval [-2]: ');
  if isempty(xu)
    xu=-2.0;
  end
  yl=f(xl);
  yu=f(xu);
  if yl*yu >= 0
    disp('Chosen interval does not include a zero')
  elseif yl >= yu
    yl=1.0; yu=1.0;
    disp('Lower guess greater than the upper guess')
  end
end
%
% Start iteration & while xu-xl>2*tol keep interval halving
%
fprintf('\nStarting iteration\n\n')
n=0;
while( (xu-xl) > 2.0*tol )
  n=n+1;
  xm=0.5*(xl+xu);
  fprintf('%2d %11.7f %13.6e %13.6e %13.6e\n',n,xm,(xu-xl)/2,yl,yu)
  ym=f(xm);
  if yl*ym < 0
 	  xu=xm;
    yu=ym;
  else
    xl=xm;
    yl=ym;
  end
end
%
% xu-xl<2*tol; calculate xm (xu-xm<tol and xm-xl<tol); output results
%
n=n+1;
xm=0.5*(xl+xu);
fprintf('%2d %11.7f %13.6e %13.6e %13.6e\n',n,xm,(xu-xl)/2,yl,yu)
fprintf('\nRoot is within %10.3e of %11.7f\n',tol,xm)